#ifndef SIMILARITY_H
#define SIMILARITY_H

#include "main.h"


#define NUM 1
#define HALF 100
#define FOREST 1
#define NOT_FOREST 0
#define UNKNOWN -1


class SimilarityCompute
{
private:
	vector< vector<int> > histgramDataSet;
	vector< vector<int> > histgramInputs;




public:
	SimilarityCompute();
	~SimilarityCompute();
	void LoadHistgramDataSet(string pathToHist, int numOfImage, int codeBookSize);
	void LoadHistgramInputs(string pathToHist, int numOfImage, int codeBookSize);
	void SaveHistgramDataSet(string pathToSave);
	double ComputeHistgramSimilarity(vector<int> hist1, vector<int> hist2);
	int JudgeForestOrNot(vector<int> InputHist);
	void IterativeJudge();


};


#endif

